﻿uses GraphWPF, Timers, MathExtensions;

var
   // таймер:
   tim: Timer;
   currentStep: integer;
   maxSteps: integer;
   spiral: array [,] of integer;
   size: integer := 41;
   // отслеживаем построенные ячейки
   builtSpiral: array [,] of boolean; 


// ГОТОВИМ СПИРАЛЬ
procedure InitializeSpiral;
begin
   spiral := new int[size, size];
   builtSpiral := new bool[size, size];
  
   var x := size div 2;
   var y := size div 2;
   var num := 1;
  
   var dirs := Arr((0,1), (1,0), (0,-1), (-1,0));
   var dirIdx := 0;
   var steps := 1;
  
   // вычисляем все клтки спирали:
  while num <= size*size do begin
     spiral[x, y] := num;
    
     for var i := 1 to 2 do begin
         var (dx, dy) := dirs[dirIdx];
         for var j := 1 to steps do begin
             x += dx;
             y += dy;
             num += 1;
             if num <= size*size then
                spiral[x, y] := num;
         end;
         dirIdx := (dirIdx + 1) mod 4;
      end;
      steps += 1;
   end;
   maxSteps := size * size;
   currentStep := 0;
end;


// РИСУЕМ КЛЕТКУ
procedure DrawCell(i, j: integer);
begin
   var cellSize := Round(Min(Window.Width, Window.Height) / size) - 2;
   var offsetX := (Window.Width - size * cellSize) / 2;
   var offsetY := (Window.Height - size * cellSize) / 2;
  
   var cellX := offsetX + j * cellSize;
   var cellY := offsetY + i * cellSize;
   var number := spiral[i, j];
  
   // рисуем клетку:
   Pen.Color := Colors.LightGray;
   Brush.Color := Colors.White;
   Rectangle(cellX, cellY, cellSize, cellSize);
  
   // закрашиваем простые числа:
   if (number.IsPrime) then begin
       Brush.Color := Colors.Blue;
       FillRectangle(cellX + 1, cellY + 1, cellSize - 2, cellSize - 2);
   end;
  
   // печатаем число:
   if cellSize > 15 then begin
      Brush.Color := Colors.Transparent;
      Font.Size := Max(6, cellSize div 3);
      var textColor := if (number.IsPrime) then Colors.White else Colors.Black;
      DrawText(cellX + 2, cellY + 2, cellSize - 4, cellSize - 4, 
               number.ToString, textColor);
   end;
end;

// АНИМАЦИЯ
procedure DrawStep;
begin
   if currentStep >= maxSteps then begin
      tim.Stop;
      exit;
   end;
  
   // координаты текущего числа в спирали:
   var found := false;
   var ci := 0;
   var cj := 0;
  
   for var i := 0 to size - 1 do begin
       for var j := 0 to size - 1 do begin
           if spiral[i, j] = currentStep + 1 then begin
              ci := i;
              cj := j;
              found := true;
              break;
          end;
       end;
      if found then break;
   end;
   
   // рисуем одну ячейку:
   if found and not builtSpiral[ci, cj] then begin
      DrawCell(ci, cj);
      builtSpiral[ci, cj] := true;
   end;
  
   currentStep += 1;
end;

// НАЧИНАЕМ АНИМАЦИЮ
procedure StartAnimation(spiralSize: int);
begin
   if tim <> nil then
      tim.Stop;
    
   size := spiralSize;
   InitializeSpiral;
  
   // очищаем окно:
   Window.Clear(Colors.White);
  
   // рисуем сетку
   var cellSize := Round(Min(Window.Width, Window.Height) / size) - 2;
   var offsetX := (Window.Width - size * cellSize) / 2;
  var offsetY := (Window.Height - size * cellSize) / 2;
  
   // рисуем пустую сетку:
   for var i := 0 to size - 1 do
       for var j := 0 to size - 1 do begin
           var cellX := offsetX + j * cellSize;
           var cellY := offsetY + i * cellSize;
      
           Pen.Color := Colors.LightGray;
           Brush.Color := Colors.White;
           Rectangle(cellX, cellY, cellSize, cellSize);
       end;
  
   // запускаем таймер:
   tim := new Timer(5, DrawStep);
   tim.Start;
end;


// ПРОЦЕДУРА ОБРАБОТКИ НАЖАТИЯ НА КЛАВИШИ
procedure KeyDown(k: Key);
begin
   case k of
        Key.D1: begin Window.SetSize(500, 500); StartAnimation(21); end;
        Key.D2: begin Window.SetSize(600, 600); StartAnimation(31); end;
        Key.D3: begin Window.SetSize(700, 700); StartAnimation(41); end;
        Key.D4: begin Window.SetSize(800, 800); StartAnimation(51); end;
        Key.Space: if tim <> nil then 
                   if tim.Enabled then tim.Stop else tim.Start;
        // перезапуск анимации:   
        Key.R: if tim <> nil then StartAnimation(size); 
        Key.Escape: Window.Close;
   end;
end;



begin
   Window.SetSize(700, 700);
   Window.CenterOnScreen;
   Window.Title := ' Анимированная спираль Улама';
  
   // запускаем анимацию:
   StartAnimation(41);
  
   // обработчик нажатия на клавиши:
   OnKeyDown := KeyDown;
  
   Writeln(' Управление:');
   Writeln(' 1-4 - выбрать размер спирали');
   Writeln(' Пробел - пауза/продолжить');
   Writeln(' R - перезапуск анимации');
   Writeln(' Esc - выход');
end.